<?php
defined('BASEPATH') OR exit('No direct script access allowed');

	class Productionmdl extends CI_model
    {
        public function get_all_job_data_for_issue()
        {
            // echo $subsql;exit();
            $barcode_query ="
                                SELECT bm.bm_id, bm.bm_item_code 
                                FROM barcode_master bm 
                                WHERE bm.bm_delete_status = 0
                                AND bm.bm_style_id != 0
                                AND bm.bm_loc = 'IN'
                            ";

            $barcode_data = $this->db->query($barcode_query)->result_array(); 
            if(!empty($barcode_data))
            {
                $record['barcode_data'][0] = 'SELECT KARIGAR';
                // foreach ($barcode_data as $key => $value) 
                // {
                //     $record['barcode_data'][$value['bm_id']] = $value['bm_item_code'];
                // }

                $record['process_data'][''] = 'SELECT'; 
                $record['process_data']['CUTTER'] = 'CUTTING'; 
                $record['process_data']['MAKER'] = 'MAKING'; 
                $record['process_data']['KANCH'] = 'KANCH'; 
                $record['process_data']['PRESS'] = 'PRESS'; 

                $record['karigar_data'][0] = 'SELECT PROCESS';
            }
            else
            {
                $record['barcode_data'][0] = 'NO PENDING BARCODE AVAILABLE';
                $record['process_data'][''] = 'NO PENDING BARCODE AVAILABLE';
                $record['karigar_data'][0] = 'NO PENDING BARCODE AVAILABLE';
            }

            $barcode_out_query ="
                                SELECT bm.bm_jim_id, bm.bm_item_code 
                                FROM barcode_master bm 
                                WHERE bm.bm_delete_status = 0
                                AND bm.bm_style_id != 0
                                AND bm.bm_loc = 'OUT'
                            ";

            $barcode_out_data = $this->db->query($barcode_out_query)->result_array(); 
            if(!empty($barcode_out_data))
            {
                $record['barcode_out_data'][0] = 'SELECT OR SCAN  BARCODE';
                foreach ($barcode_out_data as $key => $value) 
                {
                    $record['barcode_out_data'][$value['bm_jim_id']] = $value['bm_item_code'];
                }
            }
            else
            {
                $record['barcode_out_data'][0] = 'NO PENDING BARCODE AVAILABLE';
            }            
            
            return $record;
        }
        public function edit_job_issue($jim_id)
        {
            // echo $subsql;exit();
            $barcode_query ="
                                SELECT bm.bm_id, bm.bm_item_code , jim.jim_designation, jim.jim_km_id, jim.jim_id
                                FROM job_issue_master jim
                                LEFT JOIN barcode_master bm ON(bm.bm_id = jim.jim_bm_id)
                                WHERE bm.bm_delete_status = 0
                                AND bm.bm_style_id != 0
                                AND bm.bm_loc = 'OUT'
                                AND jim.jim_id = $jim_id
                            ";

            $barcode_data = $this->db->query($barcode_query)->result_array(); 
            // echo "<pre>"; print_r($barcode_data); exit();
            if($barcode_data)
            {                
                $record['process_data'][''] = 'SELECT'; 
                $record['process_data']['CUTTER'] = 'CUTTING'; 
                $record['process_data']['MAKER'] = 'MAKING'; 
                $record['process_data']['KANCH'] = 'KANCH'; 
                $record['process_data']['PRESS'] = 'PRESS'; 
                $bm_id      = $barcode_data[0]['bm_id'];
                $designation= $barcode_data[0]['jim_designation'];

                $karigar_query ="
                                    SELECT km.km_id, km.km_code
                                    FROM karigar_master km
                                    WHERE km.km_designation = '".$designation."'
                                ";
                $karigar_data = $this->db->query($karigar_query)->result_array();
                if(!empty($karigar_data))
                {
                    $record['karigar_data'][0] = 'SELECT';
                    foreach ($karigar_data as $key => $value) {
                        $record['karigar_data'][$value['km_id']] = $value['km_code'];
                    }
                }
                else
                {
                    $record['karigar_data'][0] = 'NO KARIGAR AVAILABLE';    
                }
                
                $record['barcode_data'] = $barcode_data;
                $order_query ="
                        SELECT CONCAT(UPPER(om.om_bill_series),'', om.om_entry_no) as om_entry_no, om.om_entry_date, ot.ot_trial_date, om.om_delivery_date,
                        client.client_name, app.app_name
                        FROM barcode_master bm 
                        LEFT JOIN order_trans ot ON(ot.ot_id = bm.bm_ot_id)
                        LEFT JOIN order_master om ON(om.om_id = bm.bm_om_id)
                        LEFT JOIN apparel_master app ON(app.app_id = bm.bm_app_id)
                        LEFT JOIN client_master client ON(client.client_id = bm.bm_client_name)
                        WHERE bm.bm_id = $bm_id
                        AND om.om_delete_status = 0
                    ";
                // echo $query; exit();
                $record['order_data'] = $this->db->query($order_query)->result_array();

                $issue_query ="
                            SELECT jim.*, km.*
                            FROM job_issue_master jim
                            LEFT JOIN karigar_master km ON(km.km_id = jim.jim_km_id)
                            WHERE jim.jim_bm_id = $bm_id
                            ORDER BY jim.jim_id DESC
                        ";
                // echo $query; exit();
                $record['issue_data'] = $this->db->query($issue_query)->result_array();

                $receive_query ="
                            SELECT jrm.*, km.*
                            FROM job_receive_master jrm
                            LEFT JOIN karigar_master km ON(km.km_id = jrm.jrm_km_id)
                            WHERE jrm.jrm_bm_id = $bm_id
                            ORDER BY jrm.jrm_id DESC
                        ";
                // echo $query; exit();
                $record['receive_data'] = $this->db->query($receive_query)->result_array();
            }
            else
            {
                $record['barcode_data'][0]['bm_id'] = 0;
                $record['barcode_data'][0]['bm_item_code'] = 'BARCODE ALREADY RECEIVED';
                $record['process_data'][0] = 'BARCODE ALREADY RECEIVED';
                $record['karigar_data'][0] = 'BARCODE ALREADY RECEIVED';
            }

            return $record;
        }
        public function edit_job_receive($jrm_id)
        {
            $query ="
                        SELECT jrm.*, bm.*, km.*
                        FROM job_receive_master jrm
                        LEFT JOIN barcode_master bm ON(bm.bm_id = jrm.jrm_bm_id)
                        LEFT JOIN karigar_master km ON(km.km_id = jrm.jrm_km_id)
                        WHERE bm.bm_delete_status = 0
                        AND bm.bm_style_id != 0
                        AND bm.bm_loc = 'IN'
                        AND jrm.jrm_id = $jrm_id
                    ";
            $data = $this->db->query($query)->result_array(); 
            // echo "<pre>"; print_r($data); exit();

            $barcode_query ="
                                SELECT jim.jim_id, bm.bm_item_code
                                FROM job_issue_master jim
                                LEFT JOIN barcode_master bm ON(bm.bm_id = jim.jim_bm_id)
                                WHERE bm.bm_delete_status = 0
                                AND bm.bm_loc = 'OUT'
                                AND jim.jim_km_id = ".$data[0]['jrm_km_id'];

            $barcode_data = $this->db->query($barcode_query)->result_array(); 
            // echo "<pre>"; print_r($barcode_data); exit();
            if($barcode_data)
            {                
                $record['barcode_data'][0] = 'SELECT OR SCAN  BARCODE';
                foreach ($barcode_data as $key => $value) 
                {
                    $record['barcode_data'][$value['jim_id']] = $value['bm_item_code'];
                }
            }
            else
            {
                $record['barcode_data'][0] = 'SELECT OR SCAN  BARCODE';
            }

            $record['barcode_data'][$data[0]['jrm_jim_id']] = $data[0]['bm_item_code'];
            $record['data'] = $data;
            $bm_id = $data[0]['jrm_bm_id'];

            $order_query ="
                    SELECT CONCAT(UPPER(om.om_bill_series),'', om.om_entry_no) as om_entry_no, om.om_entry_date, ot.ot_trial_date, om.om_delivery_date,
                    client.client_name, app.app_name
                    FROM barcode_master bm 
                    LEFT JOIN order_trans ot ON(ot.ot_id = bm.bm_ot_id)
                    LEFT JOIN order_master om ON(om.om_id = bm.bm_om_id)
                    LEFT JOIN apparel_master app ON(app.app_id = bm.bm_app_id)
                    LEFT JOIN client_master client ON(client.client_id = bm.bm_client_name)
                    WHERE bm.bm_id = $bm_id
                    AND om.om_delete_status = 0
                ";
            // echo $query; exit();
            $record['order_data'] = $this->db->query($order_query)->result_array();

            $issue_query ="
                        SELECT jim.*, km.*
                        FROM job_issue_master jim
                        LEFT JOIN karigar_master km ON(km.km_id = jim.jim_km_id)
                        WHERE jim.jim_bm_id = $bm_id
                        ORDER BY jim.jim_id DESC
                    ";
            // echo $query; exit();
            $record['issue_data'] = $this->db->query($issue_query)->result_array();

            $receive_query ="
                        SELECT jrm.*, km.*
                        FROM job_receive_master jrm
                        LEFT JOIN karigar_master km ON(km.km_id = jrm.jrm_km_id)
                        WHERE jrm.jrm_bm_id = $bm_id
                        ORDER BY jrm.jrm_id DESC
                    ";
            // echo $query; exit();
            $record['receive_data'] = $this->db->query($receive_query)->result_array();

            return $record;
        }
        public function order_data($bm_id)
        {
            $order_query ="
                        SELECT om.om_bill_series, om.om_entry_no, om.om_entry_date, ot.ot_trial_date, om.om_delivery_date,
                        client.client_name, app.app_name
                        FROM barcode_master bm 
                        LEFT JOIN order_trans ot ON(ot.ot_id = bm.bm_ot_id)
                        LEFT JOIN order_master om ON(om.om_id = bm.bm_om_id)
                        LEFT JOIN apparel_master app ON(app.app_id = bm.bm_app_id)
                        LEFT JOIN client_master client ON(client.client_id = bm.bm_client_name)
                        WHERE bm.bm_id = $bm_id
                        AND om.om_delete_status = 0
                    ";
            // echo $query; exit();
            $record['order_data'] = $this->db->query($order_query)->result_array();

            $issue_query ="
                        SELECT jim.*, km.*
                        FROM job_issue_master jim
                        LEFT JOIN karigar_master km ON(km.km_id = jim.jim_km_id)
                        WHERE jim.jim_bm_id = $bm_id
                        ORDER BY jim.jim_id DESC
                    ";
            // echo $query; exit();
            $record['issue_data'] = $this->db->query($issue_query)->result_array();

            $receive_query ="
                        SELECT jrm.*, km.*
                        FROM job_receive_master jrm
                        LEFT JOIN karigar_master km ON(km.km_id = jrm.jrm_km_id)
                        WHERE jrm.jrm_bm_id = $bm_id
                        ORDER BY jrm.jrm_id DESC
                    ";
            // echo $query; exit();
            $record['receive_data'] = $this->db->query($receive_query)->result_array();
            return $record;
        }
        public function get_karigar_data($designation)
        {
            $query ="
                        SELECT km.km_id, km.km_name, km.km_mobile, km.km_code
                        FROM karigar_master km
                        WHERE km.km_status = 1
                        AND km.km_designation = '$designation'
                    ";
            // echo $query; exit();
            return $this->db->query($query)->result_array();
        }
        public function get_barcode_data($km_id)
        {
            $query ="
                        SELECT bm.bm_id, bm.bm_item_code
                        FROM karigar_master km
                        LEFT JOIN karigar_group_trans kgt ON(kgt.kgt_km_id = km.km_id)
                        LEFT JOIN apparel_master app ON(app.app_group = kgt.kgt_group)
                        LEFT JOIN barcode_master bm ON(bm.bm_app_id = app.app_id)
                        WHERE km.km_id = $km_id
                        AND bm.bm_delete_status = 0
                        AND bm.bm_style_id != 0
                        AND bm.bm_loc = 'IN'
                        AND app.app_group != ''
                        GROUP BY bm.bm_id ASC
                    ";
            // echo $query; exit();
            return $this->db->query($query)->result_array();
        }
        public function get_issue_data($jim_id)
        {
            $query ="
                        SELECT jim.jim_bm_id, km.km_id, km.km_name, km.km_code, km.km_designation
                        FROM job_issue_master jim
                        LEFT JOIN karigar_master km ON(km.km_id = jim.jim_km_id)
                        WHERE jim.jim_id = $jim_id
                    ";
            // echo $query; exit();
            return $this->db->query($query)->result_array();
        }
        public function get_prev_jrm_id($jrm_id, $bm_id)
        {
            $prev_jrm_id = 0;

            $query ="
                        SELECT jrm.jrm_id
                        FROM job_receive_master jrm
                        WHERE jrm.jrm_bm_id = $bm_id
                        AND jrm.jrm_id != $jrm_id
                        ORDER BY jrm.jrm_id DESC
                        LIMIT 1
                    ";
            // echo "<pre>";print_r($query); exit;            
            $data = $this->db->query($query)->result_array();
            // echo "<pre>";print_r($data); exit;

            if (!empty($data)) {
                $prev_jrm_id = $data[0]['jrm_id'];
            }

            return $prev_jrm_id;
        }
        /****************** JOB ISSUE MASTER *******************************************************************************************/
            public function get_all_job_issue_data_cnt()
            {
                $subsql = "";
                $query  = "";
                $record = [];
                
                if(isset($_GET['jim_entry_no']) && $_GET['jim_entry_no'] > 0) {
                    $subsql .= " AND jim.jim_id =".$_GET['jim_entry_no'];
                }

                if(isset($_GET['jim_entry_date']) && $_GET['jim_entry_date'] > 0) {
                    $subsql .= " AND jim.jim_entry_date = '".date('Y-m-d', strtotime($_GET['jim_entry_date']))."'";
                }

                if(isset($_GET['bm_item_code']) && $_GET['bm_item_code'] > 0) {
                    $subsql .= " AND jim.jim_bm_id =".$_GET['bm_item_code'];
                }

                if(isset($_GET['km_name']) && $_GET['km_name'] > 0) {
                    $subsql .= " AND jim.jim_km_id =".$_GET['km_name'];
                }

                if(isset($_GET['jim_designation']) && $_GET['jim_designation'] != '') {
                    $subsql .= " AND jim.jim_designation ='".$_GET['jim_designation']."'";
                }

                if(isset($_GET['om_entry_no']) && $_GET['om_entry_no'] > 0) {
                    $subsql .= " AND om.om_id =".$_GET['om_entry_no'];
                }

                $query = "SELECT jim.jim_id 
                            FROM job_issue_master jim 
                            LEFT JOIN barcode_master bm ON(bm.bm_id = jim.jim_bm_id)
                            LEFT JOIN order_master om ON(om.om_id = bm.bm_om_id)
                            LEFT JOIN order_trans ot ON(ot.ot_id = bm.bm_ot_id)
                            LEFT JOIN apparel_master app ON(app.app_id = bm.bm_app_id)
                            LEFT JOIN karigar_master km ON(km.km_id = jim.jim_km_id)
                            LEFT JOIN client_master cm ON(cm.client_id = om.om_client_name)
                            WHERE om.om_delete_status = 0 
                            $subsql";
                            // echo "$query"; exit();
                $record= $this->db->query($query)->num_rows();
                
                return $record;
            }
            public function get_all_job_issue_data($per_page, $offset)
            {
                $subsql = "";
                $record = [];

                if(isset($_GET['jim_entry_no']) && $_GET['jim_entry_no'] > 0) {
                    $subsql .= " AND jim.jim_id =".$_GET['jim_entry_no'];
                }

                if(isset($_GET['jim_entry_date']) && $_GET['jim_entry_date'] > 0) {
                    $subsql .= " AND jim.jim_entry_date = '".date('Y-m-d', strtotime($_GET['jim_entry_date']))."'";
                }

                if(isset($_GET['bm_item_code']) && $_GET['bm_item_code'] > 0) {
                    $subsql .= " AND jim.jim_bm_id =".$_GET['bm_item_code'];
                }

                if(isset($_GET['km_name']) && $_GET['km_name'] > 0) {
                    $subsql .= " AND jim.jim_km_id =".$_GET['km_name'];
                }

                if(isset($_GET['jim_designation']) && $_GET['jim_designation'] != '') {
                    $subsql .= " AND jim.jim_designation ='".$_GET['jim_designation']."'";
                }

                if(isset($_GET['om_entry_no']) && $_GET['om_entry_no'] > 0) {
                    $subsql .= " AND om.om_id =".$_GET['om_entry_no'];
                }

                // echo $subsql;exit();
                $query ="   SELECT 
                                    jim.*, bm.*, om.*, ot.*, app.*, km.*, cm.*, CONCAT(UPPER(om.om_bill_series), '', om.om_entry_no) as om_entry_no
                            FROM job_issue_master jim 
                            LEFT JOIN barcode_master bm ON(bm.bm_id = jim.jim_bm_id)
                            LEFT JOIN order_master om ON(om.om_id = bm.bm_om_id)
                            LEFT JOIN client_master cm ON(cm.client_id = om.om_client_name)
                            LEFT JOIN order_trans ot ON(ot.ot_id = bm.bm_ot_id)
                            LEFT JOIN apparel_master app ON(app.app_id = bm.bm_app_id)
                            LEFT JOIN karigar_master km ON(km.km_id = jim.jim_km_id)
                            WHERE om.om_delete_status = 0 
                            $subsql 
                            ORDER BY jim.jim_id DESC 
                            LIMIT $per_page OFFSET $offset
                        ";

                $record['job_issue_data'] = $this->db->query($query)->result_array();
                if(!empty($record['job_issue_data']))
                {
                    foreach ($record['job_issue_data'] as $key => $value) 
                    {
                        $record['job_issue_data'][$key]['isExists'] = false;
                        $cnt = $this->db_operations->get_cnt('job_receive_master', ['jrm_jim_id' => $value['jim_id']]);
                        if($cnt != 0)
                        {
                            $record['job_issue_data'][$key]['isExists'] = true;
                        }
                    }
                } 

                // echo "<pre>";print_r($query);exit();
                /*entry no drop down*/               
                $entry_no_query = "SELECT jim.jim_id, jim.jim_entry_no FROM job_issue_master jim";

                $entry_no_data  = $this->db->query($entry_no_query)->result_array();
                $record['entry_no_data'][0] = 'SELECT';
                foreach ($entry_no_data as $key => $value) 
                {
                    $record['entry_no_data'][$value['jim_id']] = $value['jim_entry_no'];
                }

                /*entry no drop down*/               

                /*entry no drop down*/               
                $bm_item_code_query = "SELECT bm.bm_id, bm.bm_item_code 
                                        FROM job_issue_master jim 
                                        LEFT JOIN barcode_master bm ON(bm.bm_id = jim.jim_bm_id) 
                                        GROUP BY jim.jim_bm_id
                                    ";

                $bm_item_code_data  = $this->db->query($bm_item_code_query)->result_array();
                $record['bm_item_code_data'][0] = 'SELECT';
                foreach ($bm_item_code_data as $key => $value) 
                {
                    // echo "string";
                    // echo "<pre>"; print_r($value['bm']); exit;
                    $record['bm_item_code_data'][$value['bm_id']] = $value['bm_item_code'];
                }

                /*entry no drop down*/               

                /*entry no drop down*/               
                $km_name_query = "SELECT km.km_id, km.km_name, km.km_code
                                        FROM job_issue_master jim 
                                        LEFT JOIN karigar_master km ON(km.km_id = jim.jim_km_id)
                                        GROUP BY jim.jim_km_id
                                    ";

                $km_name_data  = $this->db->query($km_name_query)->result_array();
                $record['km_name_data'][0] = 'SELECT';
                foreach ($km_name_data as $key => $value) 
                {
                    // echo "string";
                    // echo "<pre>"; print_r($value['bm']); exit;
                    $record['km_name_data'][$value['km_id']] = $value['km_code'];
                }

                /*entry no drop down*/               

                /*entry no drop down*/               
                $om_entry_no_query = "SELECT om.om_id, om.om_bill_series, om.om_entry_no
                                        FROM job_issue_master jim 
                                        LEFT JOIN barcode_master bm ON(bm.bm_id = jim.jim_bm_id)
                                        LEFT JOIN order_master om ON(om.om_id = bm.bm_om_id)
                                        WHERE om.om_delete_status = 0
                                        GROUP BY bm.bm_om_id
                                    ";

                $om_entry_no_data  = $this->db->query($om_entry_no_query)->result_array();
                $record['om_entry_no_data'][0] = 'SELECT';
                foreach ($om_entry_no_data as $key => $value) 
                {
                    // echo "string";
                    // echo "<pre>"; print_r($value['bm']); exit;
                    $record['om_entry_no_data'][$value['om_id']] = $value['om_bill_series'].''.$value['om_entry_no'];
                }

                /*entry no drop down*/               

                $record['process_data'][''] = 'SELECT';
                $record['process_data']['CUTTER'] = 'CUTTING';
                $record['process_data']['MAKER'] = 'MAKING';
                $record['process_data']['KANCH'] = 'KANCH';
                $record['process_data']['PRESS'] = 'PRESS';
                return $record;
            }

            public function add_job_issue_master()
            {
                $record = [];

                $record['jim_entry_no'] = $this->db_operations->get_max_id_custom('job_issue_master', 'jim_entry_no');

                $bm_query               = "SELECT bm.bm_id, bm.bm_order_code FROM barcode_master bm WHERE bm.bm_delete_status = 0 AND bm.bm_bim_id != 0 AND (bm.bm_status = 0 OR bm.bm_status = 1) AND bm.bm_in_out = 0";
                $bm_data                = $this->db->query($bm_query)->result_array(); 

                $record['bm_data'][0] = "SELECT";
                foreach ($bm_data as $key => $value) 
                {
                    $record['bm_data'][$value['bm_id']] = $value['bm_order_code'];
                }

                
                $record['km_data'][0] = "KARIGAR";
                $record['process_data'][0] = "PROCESS";

                // echo "<pre>";print_r($record);exit();

                return $record;
            }

            public function edit_job_issue_master($jim_id)
            {
                $record = [];

                $jim_query = "SELECT jim.jim_id, jim.jim_entry_no, jim.jim_entry_date, jim.jim_total_job FROM job_issue_master jim WHERE jim.jim_id = $jim_id";
                $record['jim_data'] = $this->db->query($jim_query)->result_array();

                $jit_query = "  SELECT 
                                    jit.jit_id, jit.jit_bm_id, jit.jit_km_id, jit.jit_notes, jit.jit_process_id, jit.jit_status,
                                    bm.bm_order_code, bm.bm_entry_no, DATE_FORMAT(bm.bm_entry_date, '%d-%m-%Y') as bm_entry_date
                                    , IF(bm.bm_trial_date = '0000-00-00', '-', DATE_FORMAT(bm.bm_trial_date, '%d-%m-%Y'))  as bm_trial_date, DATE_FORMAT(bm.bm_delivery_date, '%d-%m-%Y') as bm_delivery_date, bm.bm_cutting_mtr,
                                    cm.client_name,
                                    IF(bm.bm_fm_id = 0, '-' ,CONCAT(fm.fm_no,'-', fm.fm_shade_no)) as fabric_no,
                                    km.km_name, 
                                    pm.pm_name
                                FROM job_issue_trans jit 
                                LEFT JOIN barcode_master bm ON(bm.bm_id = jit.jit_bm_id) 
                                LEFT JOIN fabric_master fm ON(fm.fm_id = bm.bm_fm_id)
                                LEFT JOIN client_master cm ON(cm.client_id = bm.bm_client_name)
                                LEFT JOIN karigar_master km ON(km.km_id = jit.jit_km_id)
                                LEFT JOIN process_master pm ON(pm.pm_id = jit.jit_process_id)
                                WHERE jit.jit_jim_id = $jim_id";
                $record['jit_data'] = $this->db->query($jit_query)->result_array();

                $bm_query               = "SELECT bm.bm_id, bm.bm_order_code FROM barcode_master bm WHERE bm.bm_bim_id != 0 AND bm.bm_status = 0";
                $bm_data                = $this->db->query($bm_query)->result_array(); 

                $record['bm_data'][0] = "SELECT";
                foreach ($bm_data as $key => $value) 
                {
                    $record['bm_data'][$value['bm_id']] = $value['bm_order_code'];
                }

                foreach ($record['jit_data'] as $key => $value) 
                {
                    $record['bm_data'][$value['jit_bm_id']] = $value['bm_order_code'];
                }

                $record['km_data'][0] = "SELECT BARCODE";
                $record['process_data'][0] = "SELECT BARCODE";


                return $record;
            }
            public function get_single_job_issue_data_for_print($jim_id)
            {
                $record = [];

                $jit_query = "  SELECT 
                                    jim.jim_id, jim.jim_entry_no, jim.jim_entry_date, jim.jim_total_job,
                                    jit.jit_id, jit.jit_bm_id, jit.jit_km_id, jit.jit_notes, jit.jit_process_id, jit.jit_status,
                                    bm.bm_order_code, bm.bm_item_code, bm.bm_entry_no, DATE_FORMAT(bm.bm_entry_date, '%d-%m-%Y') as bm_entry_date, bm.bm_ot_id,
                                    IF(bm.bm_trial_date = '0000-00-00', '-', DATE_FORMAT(bm.bm_trial_date, '%d-%m-%Y'))  as bm_trial_date, DATE_FORMAT(bm.bm_delivery_date, '%d-%m-%Y') as bm_delivery_date, bm.bm_cutting_mtr,
                                    cm.client_no,cm.client_name,
                                    IF(bm.bm_fm_id = 0, '-' ,CONCAT(fm.fm_no,'-', fm.fm_shade_no)) as fabric_no,
                                    km.km_name, 
                                    pm.pm_name,
                                    app.app_id, app.app_name,
                                    prm.pm_img
                                FROM job_issue_trans jit 
                                LEFT JOIN barcode_master bm ON(bm.bm_id = jit.jit_bm_id) 
                                LEFT JOIN job_issue_master jim ON(jim.jim_id = jit.jit_jim_id)
                                LEFT JOIN fabric_master fm ON(fm.fm_id = bm.bm_fm_id)
                                LEFT JOIN client_master cm ON(cm.client_id = bm.bm_client_name)
                                LEFT JOIN karigar_master km ON(km.km_id = jit.jit_km_id)
                                LEFT JOIN process_master pm ON(pm.pm_id = jit.jit_process_id)
                                LEFT JOIN product_master prm ON(prm.pm_id = bm.bm_pm_id)
                                LEFT JOIN apparel_master app ON(app.app_id = prm.pm_app_id)
                                WHERE jit.jit_jim_id = $jim_id";
                $record['jit_data'] = $this->db->query($jit_query)->result_array();
                // echo "<pre>"; print_r($record); exit();

                foreach ($record['jit_data'] as $key => $value) 
                {
                    $ost_query = "  SELECT 
                                        ots.*
                                    FROM 
                                        order_trans_style ots
                                    WHERE 
                                        ots.ots_ot_id = ".$value['bm_ot_id'];
                    $ots_data = $this->db->query($ost_query)->result_array();
                    if(!empty($ots_data))
                    {
                        $reverse_ots_data = array_keys($ots_data[0]);
                        foreach ($reverse_ots_data as $k => $v) 
                        {
                            
                            if(strpos($v, 'tm_id_') !== false)
                            {
                                $tm_id = substr($v, strrpos($v, '_') + 1);
                                if($ots_data[0]['tm_id_'.$tm_id] != '' && $ots_data[0]['tm_id_'.$tm_id] > 0)
                                {
                                    // echo "<pre>"; print_r($tm_id);
                                    $record['jit_data'][$key]['tm_arr'][$k]['tm_name'] = $this->db_operations->get_record('style_parameter_master' , ['tm_id'=>$tm_id])[0]['tm_name']; 
                                    $option = $this->db_operations->get_record('measure_setting_trans' ,['mst_id'=>$ots_data[0]['tm_id_'.$tm_id]]); 
                                    if(!empty($option))
                                    {
                                        $record['jit_data'][$key]['tm_arr'][$k]['value'] = $option[0]['mst_name'];     
                                    }
                                    else
                                    {
                                        $record['jit_data'][$key]['tm_arr'][$k]['value'] = $ots_data[0]['tm_id_'.$tm_id];        
                                    }
                                    // echo "<pre>"; print_r($option);exit();
                                }  
                            }
                        }

                        // echo "<pre>"; print_r($reverse_ots_data);
                    }
                    else
                    {
                        $record['jit_data'][$key]['tm_arr'] = [];
                    }
                }
                 // exit();

                $record['product_url'] = uploads('products');
                return $record;
            }


            public function get_barcode_detail($bm_id)
            {
                $bm_query = "SELECT bm.bm_entry_no, bm.bm_entry_date, bm.bm_delivery_date, bm.bm_trial_date,bm.bm_cutting_mtr,
                            cm.client_name,fm.fm_no, fm.fm_shade_no
                            FROM barcode_master bm 
                            LEFT JOIN client_master cm ON(cm.client_id = bm.bm_client_name)
                            LEFT JOIN fabric_master fm ON(fm.fm_id = bm.bm_fm_id)
                            WHERE bm.bm_id = $bm_id
                        ";
                $record['bm_data'] = $this->db->query($bm_query)->result_array();

                $km_query = "SELECT km.km_id, km.km_name
                            FROM barcode_master bm 
                            LEFT JOIN product_master pm ON(pm.pm_id = bm.bm_pm_id)
                            LEFT JOIN karigar_trans kt ON(kt.kt_app_id = pm.pm_app_id)
                            LEFT JOIN karigar_master km ON(kt.kt_km_id = km.km_id)
                            WHERE bm.bm_id = $bm_id";

                $record['km_data'] = $this->db->query($km_query)->result_array();

                $process_query ="SELECT pm.pm_id, pm.pm_name
                                FROM barcode_master bm 
                                LEFT JOIN product_process_trans ppt ON(ppt.ppt_pm_id = bm.bm_pm_id)
                                LEFT JOIN process_master pm ON(ppt.ppt_process_id = pm.pm_id)
                                WHERE bm.bm_id = $bm_id
                                AND pm.pm_name != 'Fabric Cutting'
                                ORDER BY ppt.ppt_id";

                $record['process_data'] = $this->db->query($process_query)->result_array();

                return $record;
            }
        /****************** JOB ISSUE MASTER *******************************************************************************************/

        /****************** JOB RECEIVE MASTER *****************************************************************************************/
            public function get_all_job_receive_data_cnt()
            {
                $subsql = "";
                $query  = "";
                $record = [];
                if(isset($_GET['jrm_entry_no']) && $_GET['jrm_entry_no'] > 0) {
                    $subsql .= " AND jrm.jrm_id =".$_GET['jrm_entry_no'];
                }

                if(isset($_GET['jrm_entry_date']) && $_GET['jrm_entry_date'] > 0) {
                    $subsql .= " AND jrm.jrm_entry_date = '".date('Y-m-d', strtotime($_GET['jrm_entry_date']))."'";
                }

                if(isset($_GET['bm_item_code']) && $_GET['bm_item_code'] > 0) {
                    $subsql .= " AND jrm.jrm_bm_id =".$_GET['bm_item_code'];
                }

                if(isset($_GET['km_name']) && $_GET['km_name'] > 0) {
                    $subsql .= " AND jrm.jrm_km_id =".$_GET['km_name'];
                }

                if(isset($_GET['jrm_designation']) && $_GET['jrm_designation'] != '') {
                    $subsql .= " AND jrm.jrm_designation ='".$_GET['jrm_designation']."'";
                }

                if(isset($_GET['om_entry_no']) && $_GET['om_entry_no'] > 0) {
                    $subsql .= " AND om.om_id =".$_GET['om_entry_no'];
                }
                
                $query = "SELECT jrm.jrm_id 
                            FROM job_receive_master jrm 
                            LEFT JOIN barcode_master bm ON(bm.bm_id = jrm.jrm_bm_id)
                            LEFT JOIN order_master om ON(om.om_id = bm.bm_om_id)
                            LEFT JOIN order_trans ot ON(ot.ot_id = bm.bm_ot_id)
                            LEFT JOIN apparel_master app ON(app.app_id = bm.bm_app_id)
                            LEFT JOIN karigar_master km ON(km.km_id = jrm.jrm_km_id)
                            LEFT JOIN client_master cm ON(cm.client_id = om.om_client_name)
                            WHERE om.om_delete_status = 0
                            $subsql";
                $record= $this->db->query($query)->num_rows();
                return $record;
            }
            public function get_all_job_receive_data($per_page, $offset)
            {
                $subsql = "";
                $query  = "";
                $record = [];
                if(isset($_GET['jrm_entry_no']) && $_GET['jrm_entry_no'] > 0) {
                    $subsql .= " AND jrm.jrm_id =".$_GET['jrm_entry_no'];
                }

                if(isset($_GET['jrm_entry_date']) && $_GET['jrm_entry_date'] > 0) {
                    $subsql .= " AND jrm.jrm_entry_date = '".date('Y-m-d', strtotime($_GET['jrm_entry_date']))."'";
                }

                if(isset($_GET['bm_item_code']) && $_GET['bm_item_code'] > 0) {
                    $subsql .= " AND jrm.jrm_bm_id =".$_GET['bm_item_code'];
                }

                if(isset($_GET['km_name']) && $_GET['km_name'] > 0) {
                    $subsql .= " AND jrm.jrm_km_id =".$_GET['km_name'];
                }

                if(isset($_GET['jrm_designation']) && $_GET['jrm_designation'] != '') {
                    $subsql .= " AND jrm.jrm_designation ='".$_GET['jrm_designation']."'";
                }

                if(isset($_GET['om_entry_no']) && $_GET['om_entry_no'] > 0) {
                    $subsql .= " AND om.om_id =".$_GET['om_entry_no'];
                }
                
                $query ="   SELECT jrm.*, bm.*, om.*, ot.*, app.*, km.*, cm.client_name, CONCAT(UPPER(om.om_bill_series),'',om.om_entry_no) as om_entry_no
                            FROM job_receive_master jrm
                            LEFT JOIN barcode_master bm ON(bm.bm_id = jrm.jrm_bm_id)
                            LEFT JOIN order_master om ON(om.om_id = bm.bm_om_id)
                            LEFT JOIN order_trans ot ON(ot.ot_id = bm.bm_ot_id)
                            LEFT JOIN apparel_master app ON(app.app_id = bm.bm_app_id)
                            LEFT JOIN karigar_master km ON(km.km_id = jrm.jrm_km_id)
                            LEFT JOIN client_master cm ON(cm.client_id = om.om_client_name)
                            WHERE om.om_delete_status = 0 
                            $subsql 
                            ORDER BY jrm.jrm_id DESC 
                            LIMIT $per_page 
                            OFFSET $offset
                        ";
                $record['job_receive_data'] = $this->db->query($query)->result_array(); 
                if(!empty($record['job_receive_data']))
                {
                    foreach ($record['job_receive_data'] as $key => $value) 
                    {
                        $record['job_receive_data'][$key]['isExists'] = false;
                        $cnt = $this->db_operations->get_cnt('barcode_master', ['bm_jrm_id' => $value['jrm_id'], 'bm_jim_id' => $value['jrm_jim_id']]);
                        if($cnt != 0)
                        {
                            $record['job_receive_data'][$key]['isExists'] = true;
                        }
                    }
                } 

                // echo "<pre>";print_r($query);echo "</pre>";

                // echo $query;exit();

                /*entry no drop down*/               
                $entry_no_query = "
                                    SELECT jrm.jrm_id, jrm.jrm_entry_no
                                    FROM job_receive_master jrm
                                  ";
                $entry_no_data  = $this->db->query($entry_no_query)->result_array();
                $record['entry_no_data'][0] = 'SELECT';
                foreach ($entry_no_data as $key => $value) 
                {
                    $record['entry_no_data'][$value['jrm_id']] = $value['jrm_entry_no'];
                }

                /*entry no drop down*/               

                /*entry no drop down*/               
                $bm_item_code_query = "SELECT bm.bm_id, bm.bm_item_code 
                                        FROM job_receive_master jrm 
                                        LEFT JOIN barcode_master bm ON(bm.bm_id = jrm.jrm_bm_id) 
                                        GROUP BY jrm.jrm_bm_id
                                    ";

                $bm_item_code_data  = $this->db->query($bm_item_code_query)->result_array();
                $record['bm_item_code_data'][0] = 'SELECT';
                foreach ($bm_item_code_data as $key => $value) 
                {
                    // echo "string";
                    // echo "<pre>"; print_r($value['bm']); exit;
                    $record['bm_item_code_data'][$value['bm_id']] = $value['bm_item_code'];
                }

                /*entry no drop down*/               

                /*entry no drop down*/               
                $km_name_query = "SELECT km.km_id, km.km_name, km.km_code
                                        FROM job_receive_master jrm 
                                        LEFT JOIN karigar_master km ON(km.km_id = jrm.jrm_km_id)
                                        GROUP BY jrm.jrm_km_id
                                    ";

                $km_name_data  = $this->db->query($km_name_query)->result_array();
                $record['km_name_data'][0] = 'SELECT';
                foreach ($km_name_data as $key => $value) 
                {
                    // echo "string";
                    // echo "<pre>"; print_r($value['bm']); exit;
                    $record['km_name_data'][$value['km_id']] = $value['km_code'];
                }

                /*entry no drop down*/               

                /*entry no drop down*/               
                $om_entry_no_query = "SELECT om.om_id, om.om_bill_series, om.om_entry_no
                                        FROM job_receive_master jrm 
                                        LEFT JOIN barcode_master bm ON(bm.bm_id = jrm.jrm_bm_id)
                                        LEFT JOIN order_master om ON(om.om_id = bm.bm_om_id)
                                        WHERE om.om_delete_status = 0
                                        GROUP BY bm.bm_om_id
                                    ";

                $om_entry_no_data  = $this->db->query($om_entry_no_query)->result_array();
                $record['om_entry_no_data'][0] = 'SELECT';
                foreach ($om_entry_no_data as $key => $value) 
                {
                    // echo "string";
                    // echo "<pre>"; print_r($value['bm']); exit;
                    $record['om_entry_no_data'][$value['om_id']] = $value['om_bill_series'].''.$value['om_entry_no'];
                }

                /*entry no drop down*/               

                $record['process_data'][''] = 'SELECT';
                $record['process_data']['CUTTER'] = 'CUTTING';
                $record['process_data']['MAKER'] = 'MAKING';
                $record['process_data']['KANCH'] = 'KANCH';
                $record['process_data']['PRESS'] = 'PRESS';
                return $record;
            } 
            public function add_job_receive_master()
            {
                $record = [];

                $record['jrm_entry_no'] = $this->db_operations->get_max_id_custom('job_receive_master', 'jrm_entry_no');
                $bm_query               ="  SELECT bm.bm_id, bm.bm_order_code 
                                            FROM barcode_master bm 
                                            WHERE bm.bm_status = 1 
                                            AND bm.bm_bim_id != 0
                                            AND bm.bm_jim_id != 0
                                            AND bm.bm_jit_id != 0
                                            AND bm.bm_in_out = 1
                                        ";
                $bm_data                = $this->db->query($bm_query)->result_array(); 

                $record['bm_data'][0] = "SELECT";
                foreach ($bm_data as $key => $value) 
                {
                    $record['bm_data'][$value['bm_id']] = $value['bm_order_code'];
                }

                
                $record['km_data'][0] = "SELECT BARCODE";
                $record['process_data'][0] = "SELECT BARCODE";
                


                return $record;
            }      
            public function get_job_issue_detail($bm_id)
            {
                $bm_query ="   SELECT 
                                bm.bm_entry_no, bm.bm_entry_date, bm.bm_delivery_date, bm.bm_trial_date,bm.bm_cutting_mtr, bm.bm_process_id,
                                cm.client_name,
                                fm.fm_no, fm.fm_shade_no,
                                jim.jim_entry_no, jim.jim_entry_date,
                                km.km_id, km.km_name,
                                pm.pm_id, pm.pm_name
                            FROM barcode_master bm 
                            LEFT JOIN client_master cm ON(cm.client_id = bm.bm_client_name)
                            LEFT JOIN fabric_master fm ON(fm.fm_id = bm.bm_fm_id)
                            LEFT JOIN job_issue_master jim ON(jim.jim_id = bm.bm_jim_id)
                            LEFT JOIN karigar_master km ON(bm.bm_km_id = km.km_id)
                            LEFT JOIN process_master pm ON(pm.pm_id = bm.bm_process_id)
                            WHERE bm.bm_id = $bm_id
                        ";
                $record['bm_data'] = $this->db->query($bm_query)->result_array();
                if(!empty($record['bm_data'][0]['km_id']))
                {
                    $record['km_data'][0]['km_id'] = $record['bm_data'][0]['km_id'];    
                    $record['km_data'][0]['km_name'] = $record['bm_data'][0]['km_name'];    
                }
                else
                {
                    $km_query ="    SELECT km.km_id, km.km_name
                                FROM barcode_master bm 
                                LEFT JOIN product_master pm ON(pm.pm_id = bm.bm_pm_id)
                                LEFT JOIN karigar_trans kt ON(kt.kt_app_id = pm.pm_app_id)
                                LEFT JOIN karigar_master km ON(kt.kt_km_id = km.km_id)
                                WHERE bm.bm_id = $bm_id
                            ";
                    $record['km_data'] = $this->db->query($km_query)->result_array();    
                }
                
                return $record;
            } 
            public function edit_job_receive_master($jrm_id)
            {
                $record = [];

                $jrm_query = "SELECT jrm.jrm_id, jrm.jrm_entry_no, jrm.jrm_entry_date, jrm.jrm_total_job FROM job_receive_master jrm WHERE jrm.jrm_id = $jrm_id";
                $record['jrm_data'] = $this->db->query($jrm_query)->result_array();

                $jrt_query = "  SELECT 
                                    jrt.jrt_id, jrt.jrt_ot_id, jrt.jrt_km_id, jrt.jrt_notes, jrt.jrt_status, jrt.jrt_process_id,
                                    bm.bm_order_code, bm.bm_entry_no, DATE_FORMAT(bm.bm_entry_date, '%d-%m-%Y') as bm_entry_date
                                    , IF(bm.bm_trial_date = '0000-00-00', '-', DATE_FORMAT(bm.bm_trial_date, '%d-%m-%Y'))  as bm_trial_date, DATE_FORMAT(bm.bm_delivery_date, '%d-%m-%Y') as bm_delivery_date, bm.bm_cutting_mtr,
                                    cm.client_name,
                                    IF(bm.bm_fm_id = 0, '-' ,CONCAT(fm.fm_no,'-', fm.fm_shade_no)) as fabric_no,
                                    km.km_name, pm.pm_name,
                                    jim.jim_entry_no, DATE_FORMAT(jim.jim_entry_date, '%d-%m-%Y') as jim_entry_date
                                FROM job_receive_trans jrt
                                LEFT JOIN job_issue_master jim ON(jim.jim_id = jrt.jrt_jrm_id) 
                                LEFT JOIN barcode_master bm ON(bm.bm_id = jrt.jrt_ot_id) 
                                LEFT JOIN fabric_master fm ON(fm.fm_id = bm.bm_fm_id)
                                LEFT JOIN client_master cm ON(cm.client_id = bm.bm_client_name)
                                LEFT JOIN karigar_master km ON(km.km_id = jrt.jrt_km_id)
                                LEFT JOIN process_master pm ON(pm.pm_id = jrt.jrt_process_id)
                                WHERE jrt.jrt_jrm_id = $jrm_id";
                $record['jrt_data'] = $this->db->query($jrt_query)->result_array();

                $bm_query               ="  SELECT bm.bm_id, bm.bm_order_code 
                                            FROM barcode_master bm 
                                            WHERE bm.bm_status = 1 
                                            AND bm.bm_bim_id != 0
                                            AND bm.bm_jim_id != 0
                                            AND bm.bm_jit_id != 0
                                            AND bm.bm_in_out = 1
                                        ";
                $bm_data                = $this->db->query($bm_query)->result_array(); 

                $record['bm_data'][0] = "SELECT";
                foreach ($bm_data as $key => $value) 
                {
                    $record['bm_data'][$value['bm_id']] = $value['bm_order_code'];
                }
                foreach ($record['jrt_data'] as $key => $value) 
                {
                    $record['bm_data'][$value['jrt_ot_id']] = $value['bm_order_code'];
                }

                $record['km_data'][0] = "SELECT BARCODE";
                $record['process_data'][0] = "SELECT BARCODE";
                


                return $record;
            }
        /****************** JOB RECEIVE MASTER *****************************************************************************************/

        /****************** JOB STATUS MASTER *****************************************************************************************/
            public function get_all_job_status_data_cnt()
            {
                
                $kname_search     = "";
                $cname_search      = "";
                $eno_search    = "";

                $record = [];
                
                if (isset($_GET['kname']) && (!empty($_GET['kname']))) 
                {   
                    $kname_search = " AND km.km_id = ".$_GET['kname']."";
                }

                if (isset($_GET['cname']) && (!empty($_GET['cname']))) 
                {   
                    $cname_search = " AND bm.bm_client_name = ".$_GET['cname']."";
                }

                if (isset($_GET['eno']) && (!empty($_GET['eno']))) 
                {   
                    $eno_search = " AND jim.jim_id = ".$_GET['eno']."";
                }

                $query = "SELECT 
                            bm.bm_id, bm.bm_entry_no, DATE_FORMAT(bm.bm_entry_date, '%d-%m-%Y') as bm_entry_date, bm.bm_order_code, 
                            IF(bm.bm_trial_date = '', '-', DATE_FORMAT(bm.bm_trial_date, '%d-%m-%Y')) as bm_trial_date, 
                            DATE_FORMAT(bm.bm_delivery_date, '%d-%m-%Y') as bm_delivery_date, bm.bm_status, 
                            bm.bm_in_out, bm.bm_process_id,
                            jim.jim_entry_no, DATE_FORMAT(jim.jim_entry_date, '%d-%m-%Y') as jim_entry_date, 
                            km.km_id, km.km_name,fm.fm_id, fm.fm_no, fm.fm_shade_no,fm.fm_photo
                            FROM barcode_master bm
                            LEFT JOIN job_issue_master jim ON(jim.jim_id = bm.bm_jim_id)
                            LEFT JOIN karigar_master km ON(km.km_id = bm.bm_km_id)
                            LEFT JOIN fabric_master fm ON(fm.fm_id = bm.bm_fm_id)
                            WHERE 1 
                            $kname_search $cname_search $eno_search";

                $record= $this->db->query($query)->num_rows();
                return $record;
            }

            public function get_all_job_status_data($per_page, $offset)
            {
                $kname_search     = "";
                $cname_search      = "";
                $eno_search    = "";

                $record = [];
                
                if (isset($_GET['kname']) && (!empty($_GET['kname']))) 
                {   
                    $kname_search = " AND km.km_id = ".$_GET['kname']."";
                }

                if (isset($_GET['cname']) && (!empty($_GET['cname']))) 
                {   
                    $cname_search = " AND bm.bm_client_name = ".$_GET['cname']."";
                }

                if (isset($_GET['eno']) && (!empty($_GET['eno']))) 
                {   
                    $eno_search = " AND jim.jim_id = ".$_GET['eno']."";
                }
                
                $query = "SELECT 
                            bm.bm_id, bm.bm_entry_no, DATE_FORMAT(bm.bm_entry_date, '%d-%m-%Y') as bm_entry_date, bm.bm_order_code, 
                            IF(bm.bm_trial_date = '', '-', DATE_FORMAT(bm.bm_trial_date, '%d-%m-%Y')) as bm_trial_date, 
                            DATE_FORMAT(bm.bm_delivery_date, '%d-%m-%Y') as bm_delivery_date, bm.bm_status, 
                            bm.bm_in_out, bm.bm_process_id,
                            jim.jim_entry_no, DATE_FORMAT(jim.jim_entry_date, '%d-%m-%Y') as jim_entry_date, 
                            km.km_id, km.km_name,c.client_name
                            FROM barcode_master bm
                            LEFT JOIN job_issue_master jim ON(jim.jim_id = bm.bm_jim_id)
                            LEFT JOIN karigar_master km ON(km.km_id = bm.bm_km_id)
                            LEFT JOIN client_master c ON(c.client_id = bm.bm_client_name)
                            WHERE bm.bm_delete_status = 0 
                            $kname_search $cname_search $eno_search
                            ORDER BY bm.bm_id DESC 
                            LIMIT $per_page 
                            OFFSET $offset
                        ";
                $record['job_status_data'] = $this->db->query($query)->result_array(); 

                /*process no drop down*/               
                $process_no_query = "SELECT pm.pm_name, pm.pm_id FROM process_master pm";
                $record['process_data']  = $this->db->query($process_no_query)->result_array();
                /*process no drop down*/               

                // echo "<pre>";print_r($record);exit();

                $entry_no_query = "SELECT jim.jim_id, jim.jim_entry_no FROM job_issue_master jim";

                $entry_no_data  = $this->db->query($entry_no_query)->result_array();
                $record['entry_no_data'][0] = 'SELECT';
                foreach ($entry_no_data as $key => $value) 
                {
                    $record['entry_no_data'][$value['jim_id']] = $value['jim_entry_no'];
                }


                $client_name_query = "SELECT client_id,client_name FROM client_master ORDER BY client_name ASC";
                $client_n_data = $this->db->query($client_name_query)->result_array();
                $record['client_name_data'][0] = "client name";
                foreach ($client_n_data as $key => $value) 
                {
                    $record['client_name_data'][$value['client_id']] = $value['client_name'];
                }

                $karigar_name_query = "SELECT km_id,km_name FROM karigar_master ORDER BY km_name ASC";
                $karigar_n_data = $this->db->query($karigar_name_query)->result_array();
                $record['karigar_name_data'][0] = "karigar name";
                foreach ($karigar_n_data as $key => $value) 
                {
                    $record['karigar_name_data'][$value['km_id']] = $value['km_name'];
                }

                $stat = array();
                foreach ($record['process_data'] as $key => $value) {

                    $proc_id    = $value['pm_id'];
                    $proc_name  = $value['pm_name'];
                    
                    $query = "SELECT count(bm.bm_id) as pro_count FROM barcode_master bm WHERE bm.bm_delete_status = 0 AND bm.bm_process_id = $proc_id";
                    $stat[$proc_name] = $this->db->query($query)->result_array()[0]['pro_count'];
                  
                }

                $tot_query = "SELECT count(bm.bm_id) as pro_count FROM barcode_master bm WHERE bm.bm_delete_status = 0";
                $pending_query = "SELECT count(bm.bm_id) as pro_count FROM barcode_master bm WHERE bm.bm_delete_status = 0 AND bm.bm_status = 0";
                $in_process_query = "SELECT count(bm.bm_id) as pro_count FROM barcode_master bm WHERE bm.bm_delete_status = 0 AND bm.bm_status = 1";
                $done_query = "SELECT count(bm.bm_id) as pro_count FROM barcode_master bm WHERE bm.bm_delete_status = 0 AND bm.bm_status = 2";

                $stat['TOTAL'] = $this->db->query($tot_query)->result_array()[0]['pro_count'];
                
                $stat['PENDING'] = $this->db->query($pending_query)->result_array()[0]['pro_count'];
                $stat['INPROCESS'] = $this->db->query($in_process_query)->result_array()[0]['pro_count'];
                $stat['DONE'] = $this->db->query($done_query)->result_array()[0]['pro_count'];


                $pending_per  = ($stat['PENDING'] / $stat['TOTAL']) * 100;
                $in_pro_per   = ($stat['INPROCESS'] / $stat['TOTAL']) * 100;
                $done_per     = ($stat['DONE'] / $stat['TOTAL']) * 100;

                $stat['PENDING_PER']    = round($pending_per)."%";
                $stat['INPROCESS_PER']  = round($in_pro_per)."%"; 
                $stat['DONE_PER']       = round($done_per)."%";

                $record['statistics'] = $stat;

                // echo "<pre>";print_r($record);exit();

                // echo "<pre>";print_r($record);exit();


                return $record;
            } 
            

            public function get_job_status_tot_xls()
            {
                
                /*process no drop down*/               
                $process_no_query = "SELECT pm.pm_name, pm.pm_id FROM process_master pm";
                $process_data  = $this->db->query($process_no_query)->result_array();
                /*process no drop down*/               

                // echo "<pre>";print_r($record);exit();

                $tot_query = "SELECT 
                            bm.bm_id, bm.bm_entry_no, DATE_FORMAT(bm.bm_entry_date, '%d-%m-%Y') as bm_entry_date, bm.bm_order_code, 
                            IF(bm.bm_trial_date = '', '-', DATE_FORMAT(bm.bm_trial_date, '%d-%m-%Y')) as bm_trial_date, 
                            DATE_FORMAT(bm.bm_delivery_date, '%d-%m-%Y') as bm_delivery_date, bm.bm_status, 
                            bm.bm_in_out, bm.bm_process_id,
                            jim.jim_entry_no, DATE_FORMAT(jim.jim_entry_date, '%d-%m-%Y') as jim_entry_date, 
                            km.km_id, km.km_name,c.client_name
                            FROM barcode_master bm
                            LEFT JOIN job_issue_master jim ON(jim.jim_id = bm.bm_jim_id)
                            LEFT JOIN karigar_master km ON(km.km_id = bm.bm_km_id)
                            LEFT JOIN client_master c ON(c.client_id = bm.bm_client_name)
                            WHERE bm.bm_delete_status = 0";

                $tot_result  =  $this->db->query($tot_query)->result_array();

                // echo "<pre>";print_r($tot_result);exit();
                
                $record['excel_array'][0] = array(
                        0 =>  'BARCODE',
                        1 =>  'ORDER NO',
                        2 =>  'ORDER DATE',
                        3 =>  'KARIGAR',
                        4 =>  'CLIENT',
                        5 =>  'TRIAL DATE',
                        6 =>  'DELIVERY DATE',
                        7 =>  'ISSUE NO',
                        8 =>  'ISSUE DATE',
                        9 =>  'STATUS',
                        10 =>  'ISSUE/RECEIVE',
                    );

                $ar_key = 11;
                foreach ($process_data as $key => $value) {
                   $record['excel_array'][0][$ar_key] = $value['pm_name'];
                   $ar_key++; 
                }


                foreach ($tot_result as $key => $value) 
                {
                    
                    $status = '';
                    $iss_rec = '';
                    if($value['bm_status'] == 1)
                    {
                        $status = 'In process';
                        if($value['bm_in_out'] == 1)
                        {
                            $iss_rec = 'Issue';
                        }
                        else
                        {
                            $iss_rec = 'Receive';
                        }
                    }
                    elseif($value['bm_status'] == 2)
                    {
                        $status = 'Completed';
                        if($value['bm_in_out'] == 1)
                        {
                            $iss_rec = 'Issue';
                        }
                        else
                        {
                            $iss_rec = 'Received';
                        }
                    }
                    else
                    {
                        $status = 'Pending';
                    }

                    /*excel_array*/
                    $record['excel_array'][$key+1][0] = $value['bm_order_code'];
                    $record['excel_array'][$key+1][1] = $value['bm_entry_no'];
                    $record['excel_array'][$key+1][2] = $value['bm_entry_date'];
                    $record['excel_array'][$key+1][3] = $value['km_name'];
                    $record['excel_array'][$key+1][4] = $value['client_name'];
                    $record['excel_array'][$key+1][5] = $value['bm_trial_date'];
                    $record['excel_array'][$key+1][6] = $value['bm_delivery_date'];
                    $record['excel_array'][$key+1][7] = $value['jim_entry_no'];
                    $record['excel_array'][$key+1][8] = $value['jim_entry_date'];
                    $record['excel_array'][$key+1][9] = $status;
                    $record['excel_array'][$key+1][10] = $iss_rec;
                    
                    $ar_key2 = 11;
                    foreach ($process_data as $key1 => $value1) {

                        if($value1['pm_id'] == $value['bm_process_id']) {
                            $record['excel_array'][$key+1][$ar_key2] = $value['km_name'];
                        }
                        else{
                        $record['excel_array'][$key+1][$ar_key2] = "";

                        }
                       $ar_key2++; 
                    }
                }

                // echo "<pre>";print_r($record['excel_array']);exit();

                return $record;
            } 


            public function get_job_status_complete_xls()
            {
                
                /*process no drop down*/               
                $process_no_query = "SELECT pm.pm_name, pm.pm_id FROM process_master pm";
                $process_data  = $this->db->query($process_no_query)->result_array();
                /*process no drop down*/               

                // echo "<pre>";print_r($record);exit();

                $tot_query = "SELECT 
                            bm.bm_id, bm.bm_entry_no, DATE_FORMAT(bm.bm_entry_date, '%d-%m-%Y') as bm_entry_date, bm.bm_order_code, 
                            IF(bm.bm_trial_date = '', '-', DATE_FORMAT(bm.bm_trial_date, '%d-%m-%Y')) as bm_trial_date, 
                            DATE_FORMAT(bm.bm_delivery_date, '%d-%m-%Y') as bm_delivery_date, bm.bm_status, 
                            bm.bm_in_out, bm.bm_process_id,
                            jim.jim_entry_no, DATE_FORMAT(jim.jim_entry_date, '%d-%m-%Y') as jim_entry_date, 
                            km.km_id, km.km_name,c.client_name
                            FROM barcode_master bm
                            LEFT JOIN job_issue_master jim ON(jim.jim_id = bm.bm_jim_id)
                            LEFT JOIN karigar_master km ON(km.km_id = bm.bm_km_id)
                            LEFT JOIN client_master c ON(c.client_id = bm.bm_client_name)
                            WHERE bm.bm_delete_status = 0 AND bm.bm_status = 2";

                $tot_result  =  $this->db->query($tot_query)->result_array();

                // echo "<pre>";print_r($tot_result);exit();
                
                $record['excel_array'][0] = array(
                        0 =>  'BARCODE',
                        1 =>  'ORDER NO',
                        2 =>  'ORDER DATE',
                        3 =>  'KARIGAR',
                        4 =>  'CLIENT',
                        5 =>  'TRIAL DATE',
                        6 =>  'DELIVERY DATE',
                        7 =>  'ISSUE NO',
                        8 =>  'ISSUE DATE',
                        9 =>  'STATUS',
                        10 =>  'ISSUE/RECEIVE',
                    );

                $ar_key = 11;
                foreach ($process_data as $key => $value) {
                   $record['excel_array'][0][$ar_key] = $value['pm_name'];
                   $ar_key++; 
                }


                foreach ($tot_result as $key => $value) 
                {
                    
                    $status = '';
                    $iss_rec = '';
                    if($value['bm_status'] == 1)
                    {
                        $status = 'In process';
                        if($value['bm_in_out'] == 1)
                        {
                            $iss_rec = 'Issue';
                        }
                        else
                        {
                            $iss_rec = 'Receive';
                        }
                    }
                    elseif($value['bm_status'] == 2)
                    {
                        $status = 'Completed';
                        if($value['bm_in_out'] == 1)
                        {
                            $iss_rec = 'Issue';
                        }
                        else
                        {
                            $iss_rec = 'Received';
                        }
                    }
                    else
                    {
                        $status = 'Pending';
                    }

                    /*excel_array*/
                    $record['excel_array'][$key+1][0] = $value['bm_order_code'];
                    $record['excel_array'][$key+1][1] = $value['bm_entry_no'];
                    $record['excel_array'][$key+1][2] = $value['bm_entry_date'];
                    $record['excel_array'][$key+1][3] = $value['km_name'];
                    $record['excel_array'][$key+1][4] = $value['client_name'];
                    $record['excel_array'][$key+1][5] = $value['bm_trial_date'];
                    $record['excel_array'][$key+1][6] = $value['bm_delivery_date'];
                    $record['excel_array'][$key+1][7] = $value['jim_entry_no'];
                    $record['excel_array'][$key+1][8] = $value['jim_entry_date'];
                    $record['excel_array'][$key+1][9] = $status;
                    $record['excel_array'][$key+1][10] = $iss_rec;
                    
                    $ar_key2 = 11;
                    foreach ($process_data as $key1 => $value1) {

                        if($value1['pm_id'] == $value['bm_process_id']) {
                            $record['excel_array'][$key+1][$ar_key2] = $value['km_name'];
                        }
                        else{
                        $record['excel_array'][$key+1][$ar_key2] = "";

                        }
                       $ar_key2++; 
                    }
                }

                // echo "<pre>";print_r($record['excel_array']);exit();

                return $record;
            } 

            public function get_job_status_inprocess_xls()
            {
                
                /*process no drop down*/               
                $process_no_query = "SELECT pm.pm_name, pm.pm_id FROM process_master pm";
                $process_data  = $this->db->query($process_no_query)->result_array();
                /*process no drop down*/               

                // echo "<pre>";print_r($record);exit();

                $tot_query = "SELECT 
                            bm.bm_id, bm.bm_entry_no, DATE_FORMAT(bm.bm_entry_date, '%d-%m-%Y') as bm_entry_date, bm.bm_order_code, 
                            IF(bm.bm_trial_date = '', '-', DATE_FORMAT(bm.bm_trial_date, '%d-%m-%Y')) as bm_trial_date, 
                            DATE_FORMAT(bm.bm_delivery_date, '%d-%m-%Y') as bm_delivery_date, bm.bm_status, 
                            bm.bm_in_out, bm.bm_process_id,
                            jim.jim_entry_no, DATE_FORMAT(jim.jim_entry_date, '%d-%m-%Y') as jim_entry_date, 
                            km.km_id, km.km_name,c.client_name
                            FROM barcode_master bm
                            LEFT JOIN job_issue_master jim ON(jim.jim_id = bm.bm_jim_id)
                            LEFT JOIN karigar_master km ON(km.km_id = bm.bm_km_id)
                            LEFT JOIN client_master c ON(c.client_id = bm.bm_client_name)
                            WHERE bm.bm_delete_status = 0 AND bm.bm_status = 1";

                $tot_result  =  $this->db->query($tot_query)->result_array();

                // echo "<pre>";print_r($tot_result);exit();
                
                $record['excel_array'][0] = array(
                        0 =>  'BARCODE',
                        1 =>  'ORDER NO',
                        2 =>  'ORDER DATE',
                        3 =>  'KARIGAR',
                        4 =>  'CLIENT',
                        5 =>  'TRIAL DATE',
                        6 =>  'DELIVERY DATE',
                        7 =>  'ISSUE NO',
                        8 =>  'ISSUE DATE',
                        9 =>  'STATUS',
                        10 =>  'ISSUE/RECEIVE',
                    );

                $ar_key = 11;
                foreach ($process_data as $key => $value) {
                   $record['excel_array'][0][$ar_key] = $value['pm_name'];
                   $ar_key++; 
                }


                foreach ($tot_result as $key => $value) 
                {
                    
                    $status = '';
                    $iss_rec = '';
                    if($value['bm_status'] == 1)
                    {
                        $status = 'In process';
                        if($value['bm_in_out'] == 1)
                        {
                            $iss_rec = 'Issue';
                        }
                        else
                        {
                            $iss_rec = 'Receive';
                        }
                    }
                    elseif($value['bm_status'] == 2)
                    {
                        $status = 'Completed';
                        if($value['bm_in_out'] == 1)
                        {
                            $iss_rec = 'Issue';
                        }
                        else
                        {
                            $iss_rec = 'Received';
                        }
                    }
                    else
                    {
                        $status = 'Pending';
                    }

                    /*excel_array*/
                    $record['excel_array'][$key+1][0] = $value['bm_order_code'];
                    $record['excel_array'][$key+1][1] = $value['bm_entry_no'];
                    $record['excel_array'][$key+1][2] = $value['bm_entry_date'];
                    $record['excel_array'][$key+1][3] = $value['km_name'];
                    $record['excel_array'][$key+1][4] = $value['client_name'];
                    $record['excel_array'][$key+1][5] = $value['bm_trial_date'];
                    $record['excel_array'][$key+1][6] = $value['bm_delivery_date'];
                    $record['excel_array'][$key+1][7] = $value['jim_entry_no'];
                    $record['excel_array'][$key+1][8] = $value['jim_entry_date'];
                    $record['excel_array'][$key+1][9] = $status;
                    $record['excel_array'][$key+1][10] = $iss_rec;
                    
                    $ar_key2 = 11;
                    foreach ($process_data as $key1 => $value1) {

                        if($value1['pm_id'] == $value['bm_process_id']) {
                            $record['excel_array'][$key+1][$ar_key2] = $value['km_name'];
                        }
                        else{
                        $record['excel_array'][$key+1][$ar_key2] = "";

                        }
                       $ar_key2++; 
                    }
                }

                // echo "<pre>";print_r($record['excel_array']);exit();

                return $record;
            } 

            public function get_job_status_pending_xls()
            {
                
                /*process no drop down*/               
                $process_no_query = "SELECT pm.pm_name, pm.pm_id FROM process_master pm";
                $process_data  = $this->db->query($process_no_query)->result_array();
                /*process no drop down*/               

                // echo "<pre>";print_r($record);exit();

                $tot_query = "SELECT 
                            bm.bm_id, bm.bm_entry_no, DATE_FORMAT(bm.bm_entry_date, '%d-%m-%Y') as bm_entry_date, bm.bm_order_code, 
                            IF(bm.bm_trial_date = '', '-', DATE_FORMAT(bm.bm_trial_date, '%d-%m-%Y')) as bm_trial_date, 
                            DATE_FORMAT(bm.bm_delivery_date, '%d-%m-%Y') as bm_delivery_date, bm.bm_status, 
                            bm.bm_in_out, bm.bm_process_id,
                            jim.jim_entry_no, DATE_FORMAT(jim.jim_entry_date, '%d-%m-%Y') as jim_entry_date, 
                            km.km_id, km.km_name,c.client_name
                            FROM barcode_master bm
                            LEFT JOIN job_issue_master jim ON(jim.jim_id = bm.bm_jim_id)
                            LEFT JOIN karigar_master km ON(km.km_id = bm.bm_km_id)
                            LEFT JOIN client_master c ON(c.client_id = bm.bm_client_name)
                            WHERE bm.bm_delete_status = 0 AND bm.bm_status = 0";

                $tot_result  =  $this->db->query($tot_query)->result_array();

                // echo "<pre>";print_r($tot_result);exit();
                
                $record['excel_array'][0] = array(
                        0 =>  'BARCODE',
                        1 =>  'ORDER NO',
                        2 =>  'ORDER DATE',
                        3 =>  'KARIGAR',
                        4 =>  'CLIENT',
                        5 =>  'TRIAL DATE',
                        6 =>  'DELIVERY DATE',
                        7 =>  'ISSUE NO',
                        8 =>  'ISSUE DATE',
                        9 =>  'STATUS',
                        10 =>  'ISSUE/RECEIVE',
                    );

                $ar_key = 11;
                foreach ($process_data as $key => $value) {
                   $record['excel_array'][0][$ar_key] = $value['pm_name'];
                   $ar_key++; 
                }


                foreach ($tot_result as $key => $value) 
                {
                    
                    $status = '';
                    $iss_rec = '';
                    if($value['bm_status'] == 1)
                    {
                        $status = 'In process';
                        if($value['bm_in_out'] == 1)
                        {
                            $iss_rec = 'Issue';
                        }
                        else
                        {
                            $iss_rec = 'Receive';
                        }
                    }
                    elseif($value['bm_status'] == 2)
                    {
                        $status = 'Completed';
                        if($value['bm_in_out'] == 1)
                        {
                            $iss_rec = 'Issue';
                        }
                        else
                        {
                            $iss_rec = 'Received';
                        }
                    }
                    else
                    {
                        $status = 'Pending';
                    }

                    /*excel_array*/
                    $record['excel_array'][$key+1][0] = $value['bm_order_code'];
                    $record['excel_array'][$key+1][1] = $value['bm_entry_no'];
                    $record['excel_array'][$key+1][2] = $value['bm_entry_date'];
                    $record['excel_array'][$key+1][3] = $value['km_name'];
                    $record['excel_array'][$key+1][4] = $value['client_name'];
                    $record['excel_array'][$key+1][5] = $value['bm_trial_date'];
                    $record['excel_array'][$key+1][6] = $value['bm_delivery_date'];
                    $record['excel_array'][$key+1][7] = $value['jim_entry_no'];
                    $record['excel_array'][$key+1][8] = $value['jim_entry_date'];
                    $record['excel_array'][$key+1][9] = $status;
                    $record['excel_array'][$key+1][10] = $iss_rec;
                    
                    $ar_key2 = 11;
                    foreach ($process_data as $key1 => $value1) {

                        if($value1['pm_id'] == $value['bm_process_id']) {
                            $record['excel_array'][$key+1][$ar_key2] = $value['km_name'];
                        }
                        else{
                        $record['excel_array'][$key+1][$ar_key2] = "";

                        }
                       $ar_key2++; 
                    }
                }

                // echo "<pre>";print_r($record['excel_array']);exit();

                return $record;
            } 
        /****************** JOB STATUS MASTER *****************************************************************************************/

	}
?>