<?php
// Include the main TCPDF library (search for installation path).
$this->mypdf_class->tcpdf(); 
global $master_pdf; 
global $ot_data_pdf;

global $yy;
$master_pdf      = $order_data; 
$ot_data_pdf     = $order_trans_data;

// echo "<pre>";print_r($master_pdf[0]);
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF 
{
    //Page header
    public function Header() 
    { 
        global $master_pdf; 

        // $logo =base_url('public/assets/img/a_logo.png');
        $logo =base_url('public/assets/img/ar1.png');
        $customer_name = !empty($master_pdf[0]['om_client_id2'])?$master_pdf[0]['om_client_id2']:'';
        $customer_mobile = !empty($master_pdf[0]['client_mobile1'])?$master_pdf[0]['client_mobile1']:'';
        $customer_gst_no = !empty($master_pdf[0]['client_gst_no'])?$master_pdf[0]['client_gst_no']:'';

        $order_date         = date('d-m-Y',strtotime($master_pdf[0]['om_date']));
        $trial_date     = empty($master_pdf) || $master_pdf[0]['om_trial_date'] == '0000-00-00' || $master_pdf[0]['om_trial_date'] == '1970-01-01' || $master_pdf[0]['om_trial_date'] == ''  ? "" : date('d-m-Y',strtotime($master_pdf[0]['om_trial_date']));
        $delivery_date      = date('d-m-Y',strtotime($master_pdf[0]['om_delivery_date']));

        // $this->SetFont('copperplateccheavy', '', 9,false);
        $this->SetFont('Times', 'B', 15);

        // $this->SetFont('Lato', '', 11);
       

        // $fontname = TCPDF_FONTS::addTTFfont('public/assets/fonts/lato-regular.ttf', 'TrueTypeUnicode', '', 96,'true');

        // $this->SetFont($fontname, '', 11);

        $tbl_header ='';
        $tbl_header .= '
                    <table cellpadding="1" border="0" > 
                        <tr>
                            <td width="100%" style="text-align:right;">Estimate</td>
                        </tr>
                        <tr>
                            <td width="30%" style="text-align:center;"><img src="'.$logo.'" height="100px"></td>
                            <td width="5%" ></td>
                            <td width="65%" style="font-weight:normal;font-size:16px;"><b style="color:red;">ARISTO & SON`S </b><br/>
                            <span style="font-size:12px;">C/o. 363,MINERVA MANSION, S.V.P ROAD ,<br/> MUMBAI - 400004 </span><br/>
                                <span style="font-size:11px;">MOB:- 23825926 / 23889735 / 9326684839 </span><br/>
                                <span style="font-size:15px;">GSTIN: 27AASPP2262P1ZV </span>
                            </td>
                        </tr>
                    </table>
                    <table cellpadding="4" border="1"  style="border-radius:50px;font-size:12px;border-top-color:black">
                        <tr>
                            <td width="67%"><b>Client Name : '.$customer_name.'</b></td>
                            <td width="33%"><b>Ord No  : '.$master_pdf[0]['om_no'].'</b></td>
                        </tr>
                        <tr>
                            <td><b>Mob. : '.$customer_mobile.'</b></td>
                            <td><b>Ord Date : '.$order_date.'</b></td>
                        </tr>
                        <tr>
                            <td><b>Address  : '.$master_pdf[0]['client_home_address'].'</b></td>
                            <td><b>Delivery Date   : '.$delivery_date.'</b></td>
                        </tr>';
                        if(!empty($trial_date))
                        {
                            $tbl_header .= '<tr>
                            <td></td>
                            <td style="font-size:12px"><b>Trial Date &nbsp; : '.$trial_date.'</b></td>
                            </tr>';
                        }
                    $tbl_header .= '
                    </table>
                      
                    <table  border="1" cellpadding="2" style="padding-top:15px;">
                        <tr>
                            <th style="width:4%; font-size:13px"><b>Sr</b></th>
                            <th style="width:27%; font-size:13px"><b>Product</b></th>
                            <th style="width:36%;text-align:center; font-size:13px"><b>Description</b></th>
                            <th style="width:8%;text-align:center; font-size:13px"><b>Qty</b></th>
                            
                            <th style="width:12%;text-align:center; font-size:13px"><b>Rate</b></th>
                            <th style="width:13%;text-align:center; font-size:13px"><b>Amount</b></th>
                        </tr>
                    </table>';

        $this->writeHTML($tbl_header, true, false, false, false, '');
        $yy = $this->GetY(); 
        $yy = $yy - 8;
        
        $this->line(5,$yy,5,161);
        $this->line(10.4,$yy,10.4,140);
        $this->line(47.8,$yy,47.8,140);
        $this->line(97.5,$yy,97.5,161);
        $this->line(108.5,$yy,108.5,140);       
        $this->line(125,$yy,125,140);
        $this->line(143,$yy,143,140);
        $this->line(205,$yy,205,217);

        $this->SetTopMargin($yy + 1);
    }

    // Page footer
    public function Footer() 
    {
        // $gpay =base_url('public/assets/img/order_bill_gpay.jpeg');
        $gpay ='';
        // $this->SetFont('copperplateccheavy', 'B', 10,false);
        $this->SetFont('Times', 13);
        global $master_pdf;
        global $ot_data_pdf;

        $amt_words  = number_to_word($master_pdf[0]['om_final_total']);
      
        $tbl_footer ='';
        $tbl_footer .='<table width="100%"  border="0" style="border:1px solid #000;" cellpadding="4" >
            <tr style="font-size:12px;">
                <th style="width:67%;text-align:right;">&nbsp;&nbsp;&nbsp;<b>Total Qty</b> </th>
                <th style="width:8%;text-align:center;">'.$master_pdf[0]['om_total_qty'].'</th>
                <th style="width:12%;" align="left"><b>Sub Total</b></th>
                <th style="width:13%;text-align:right"><b>'.$master_pdf[0]['om_gross_total'].'</b></th>
            </tr>
        </table>
       <table border="1" cellpadding="2">
        <tr>
            <td width="67%" style="font-size:12px;">
                <table>
                    <tr>
                        <td style="font-size:12px;" align="left">Amt. in Words : '.$amt_words.'</td>
                    </tr>
                </table>
            </td>
            <td width="33%">
                <table style="line-height: 1.8;" border="0">';
                if($master_pdf[0]['om_disc_amt'] >0)
                {
                $tbl_footer .='<tr>
                    <td width="45%" style="font-size:11px;" align="left"><b>Disc Amt </b></td>
                    <td width="55%"style="font-size:11px;" align="right"><b>&nbsp;&nbsp;'.$master_pdf[0]['om_disc_amt'].'</b></td>
                </tr>';
                }
            $tbl_footer .='</table>
            </td>       
         </tr>
         <tr>
            <td width="67%">
                <table>
                    <tr>
                        <td height="35px;">1.  Any alteration after two weeks of delivery is chargeable<br/>
                        2.  We are not responsible, if the delivery is not taken within two months from the date appointed.<br/>
                        3.  Delivery in the evening after 6:00 PM.<br/>
                            
                        4.  Delivery of items will be done on full clearance of invoice amount<br/>
                        Time 10:00 AM to 8:PM (Sunday Closed)
                        </td>
                        
                    </tr>
                </table>
            </td>
            <td width="33%">
                <table border="0" cellpadding="2">
                    <tr>
                        <td width="55%" style="font-size:11px;border-bottom:1px solid #000;" align="left"><b>FINAL AMT</b> </td>
                        <td width="45%" style="font-size:11px;border-bottom:1px solid #000;" align="right"><b>'.$master_pdf[0]['om_final_total'].'</b></td>
                    </tr>';

                    if($master_pdf[0]['om_advance'] >0)
                    {
                    $tbl_footer .='<tr>
                        <td width="55%" style="font-size:11px;border-bottom:1px solid #000;" align="left"><b>ADVANCE </b></td>
                        <td width="45%"style="font-size:11px;border-bottom:1px solid #000;" align="right"><b>&nbsp;&nbsp;'.$master_pdf[0]['om_advance'].'</b></td>
                    </tr>';
                    }

                    if($master_pdf[0]['om_roundoff'] >0)
                    {
                    $tbl_footer .='<tr>
                        <td width="55%" style="font-size:11px;" align="left"><b>ROUND OFF </b></td>
                        <td width="45%"style="font-size:11px;" align="right"><b>&nbsp;&nbsp;'.$master_pdf[0]['om_roundoff'].'</b></td>
                    </tr>';
                    }

                    $tbl_footer .='<tr>
                        <td width="50%" style="font-size:11px;border-bottom:1px solid #000;" align="left"><b>BALANCE</b></td>
                        <td width="50%" style="font-size:11px;border-bottom:1px solid #000;" align="right"><b>'.$master_pdf[0]['om_balance'].' </b>&nbsp;</td> 
                    </tr>';

                    $tbl_footer .='
                </table>
            </td>
         </tr>
            
        </table>
        <table cellpadding="1" border="0"  style="font-weight:bold;font-size:12px;">
            <tr>
                <td width="67%" >
                    <table  cellpadding="1">
                        <tr>
                            <td width="80%">
                                Customer`s Signature
                            </td>
                        </tr>
                    </table>
                </td>
                <td width="33%">
                    <table cellpadding="2">';
                       $tbl_footer .='<tr>
                            <td width="100%" style="text-align:center;">
                                For ARISTO & SON`S<br/>
                                <br/>
                                Signature
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>';

        $this->writeHTML($tbl_footer, true, false, false, false, '');
        // Set font
        // $this->SetFont('copperplateccheavy', 'I', 9);
        $this->SetFont('Times', 13);
        // Page number
        $this->Cell(0, 0, 'Page '.$this->getPageNumGroupAlias().'/'.$this->getPageGroupAlias(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, array('200','148'), true, 'UTF-8', false); 

// set document information
$file_name  = $master_pdf[0]['om_id'].".pdf";
$file_path  = 'public/uploads/order/'.$file_name;

$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Imran Khan');
$pdf->SetTitle('ORDER INVOICE Pdf');
$pdf->SetSubject('ORDER INVOICE Pdf');
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(5, PDF_MARGIN_TOP, 5,true);
$pdf->SetHeaderMargin(3);
$pdf->SetFooterMargin(60);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, 58);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
    require_once(dirname(__FILE__).'/lang/eng.php');
    $pdf->setLanguageArray($l);
}


// $pdf->SetFont('copperplateccheavy', '', 13,false);
$pdf->SetFont('Times', 13);
$body = "";
$title = "Original for Buyer";
$pdf->startPageGroup();
$pdf->AddPage();

$body .= '<table cellpadding="2" >';
            foreach($ot_data_pdf as $key => $value) :

                $item_name      = $value['app_name'];
                $rate           = $value['ot_rate'];
                $chart_no       = $value['ot_chart_no'];
                $desc           = $value['ot_desc'];
                $item_qty       = $value['ot_qty'];
                $amount         = $item_qty * $rate;

                $body .= '<tr style="font-size:11px;">
                            <td style="width:4.3%;border-bottom-color:#ccc;text-align:center;">'.($key+1).'</td>
                            <td style="width:27%;border-bottom-color:#ccc;">'.$item_name.'</td>
                            <td style="width:34%;text-align:center;border-bottom-color:#ccc;">'.$desc.'</td>
                            <td style="width:10%;text-align:center;border-bottom-color:#ccc;">'.$item_qty.'</td>
                            
                            <td style="width:12%;text-align:right;border-bottom-color:#ccc;">'.$rate.'</td>
                            <td style="width:13%;text-align:right;border-bottom-color:#ccc;">'.$amount.'</td>
                        </tr>';
            endforeach;
$body .= '</table>'; 


$pdf->writeHTML($body, true, false, false, false, '');

//Close and output PDF document
if(true)
{

    $pdf->Output($file_path, 'F');
}


//============================================================+
// END OF FILE
//============================================================+