$(document).ready(() => {   
	$("#jim_id")
		.select2(
			select2_default({
				url: `production/job_issue/get_select2_entry_no`,
				placeholder: "ISSUE NO",
			})
		).on("change", () => trigger_search());
	$("#app_id")
	.select2(
		select2_default({
			url: `production/job_issue/get_select2_apparel`,
			placeholder: "APPAREL NO",
		})
	).on("change", () => trigger_search());
	$("#bm_id")
		.select2(
			select2_default({
				url: `production/job_issue/get_select2_barcode`,
				placeholder: "BARCODE",
			})
		).on("change", () => trigger_search());
	$("#km_id")
		.select2(
			select2_default({
				url: `production/job_issue/get_select2_karigar`,
				placeholder: "KARIGAR",
			})
		)
		.on("change", () => trigger_search());
	$("#app_id")
		.select2(
			select2_default({
				url: `production/job_issue/get_select2_apparel`,
				placeholder: "APPAREL",
			})
		)
		.on("change", () => trigger_search());
	$("#client_id")
		.select2(
			select2_default({
				url: `production/job_issue/get_select2_client`,
				placeholder: "CLIENT - CODE",
			})
		)
		.on("change", () => trigger_search());
	$("#om_id")
		.select2(
			select2_default({
				url: `production/job_issue/get_select2_order`,
				placeholder: "ORDER NO",
			})
		)
		.on("change", () => trigger_search());
	$("#km_process")
		.select2(
			select2_default({
				url: `production/job_issue/get_select2_proces`,
				placeholder: "PROCESS",
			})
		)
		.on("change", () => trigger_search());	
});
const get_karigar = () => {
	let designation = $("#jim_km_designation").val();
	$("#jim_km_id").html("<option value=0>SELECT PROCESS FIRST</option>");
	$("#jim_km_id").prop("disabled", true).val(0);
	$("#ot_barcode")
		.prop("placeholder", "SELECT KARIGAR FIRST")
		.prop("disabled", true)
		.val("");
	$("#job_issue_body_wrapper").empty();
	$("#pending_job_wrapper").html("");
	set_header();
	if (designation != "") {
		let path = `${base_url}/production/job_issue/get_karigar/${designation}`;
		ajaxCall(
			"GET",
			path,
			"",
			"JSON",
			(resp) => {
				const { status, flag, data, msg } = resp;
				if (status) {
					if (flag == 1) {
						if (data && data.length != 0) {
							let options = "<option value=0>SELECT</option>";
							data.forEach((karigar) => {
								options += `<option value=${karigar.km_id}>${karigar.km_name}</option>`;
							});
							$("#jim_km_id").html(options);
							$("#jim_km_id").prop("disabled", false).val(0);
						} else {
							$("#jim_km_id").html("<option value=0>NO KARIGAR FOUND</option>");
							$("#jim_km_id").val(0);
						}
					} else {
						response_error(flag, msg);
					}
				} else {
					session_expired();
				}
			},
			(errmsg) => {}
		);
	}
};

const get_barcode = () => { 

	let id = $("#jim_km_id").val();
	let _from_date =
		$("#_from_date").val() == ""
			? $("#jim_entry_date").val()
			: $("#_from_date").val();
	let _to_date =
		$("#_to_date").val() == ""
			? $("#jim_entry_date").val()
			: $("#_to_date").val();
	$("#ot_barcode")
		.prop("placeholder", "SELECT KARIGAR FIRST")
		.prop("disabled", true)
		.val("");
	$("#job_issue_body_wrapper").empty();
	$("#pending_job_wrapper").html("");
	set_header();
	if (id != 0) { 
		let path = `${base_url}/production/job_issue/get_barcode/${id}/${_from_date}/${_to_date}`;
		ajaxCall(
			"GET",
			path,
			"",
			"JSON",
			(resp) => {
				const { status, flag, data, msg } = resp;
				if (status) {
					if (flag == 1) {
						if (data) {
							const { barcode_data, pending_job } = data;
							if (barcode_data && barcode_data.length != 0) {
								$("#ot_barcode")
									.prop("placeholder", "SCAN BARCODE")
									.prop("disabled", false)
									.val("");
							} else {
								$("#ot_barcode")
									.prop("placeholder", "NO BARCODE FOUND")
									.prop("disabled", true)
									.val("");
							}

							if (pending_job && pending_job.length != 0) {
								let tr = "";
								let sr_no = 0;
								pending_job.forEach((row) => {
									const { order_no, issue_date, product } = row;
									sr_no++;
									tr += `<tr>
                                        <td width="5%">${sr_no}</td>
                                        <td width="10%">${order_no}</td>
                                        <td width="10%">${issue_date}</td>
                                        <td width="40%">${product}</td>
                                        <td width="35%"></td>
                                    </tr>`;
								});
								$("#pending_job_wrapper").html(tr);
							}
						}
					} else {
						response_error(flag, msg);
					}
				} else {
					session_expired();
				}
			},
			(errmsg) => {}
		);
	}
};
const get_pending_job = () => { 
	let id = $("#jim_km_id").val();
	let _from_date = $("#_from_date").val();
	let _to_date = $("#_to_date").val();
	$("#ot_barcode")
		.prop("placeholder", "SELECT KARIGAR FIRST")
		.prop("disabled", true)
		.val("");
	$("#job_issue_body_wrapper").empty();
	$("#pending_job_wrapper").html("");
	set_header();
	if (id != 0 && _from_date != "" && _to_date != "") {
		let path = `${base_url}/production/job_issue/get_pending_job/${id}/${_from_date}/${_to_date}`;
		ajaxCall(
			"GET",
			path,
			"",
			"JSON",
			(resp) => {
				const { status, flag, data, msg } = resp;
				if (status) {
					if (flag == 1) {
						if (data) {
							const { barcode_data, pending_job } = data;
							if (pending_job && pending_job.length != 0) {
								let tr = "";
								let tr1 = "";
								let sr_no = 0;
								pending_job.forEach((row) => {
									const { order_no, issue_date, app_name } = row;
									sr_no++;
									tr += `<tr>
                                        <td width="5%">${sr_no}</td>
                                        <td width="10%">${order_no}</td>
                                        <td width="10%">${issue_date}</td>
                                        <td width="40%">${app_name}</td>
                                        <th width="35%"></th>
                                    </tr>`;

								});

								$("#pending_job_wrapper").html(tr);
								
							}
						}
					} else {
						response_error(flag, msg);
					}
				} else {
					session_expired();
				}
			},
			(errmsg) => {}
		);
	}
};
const calculate_issued_count = () => {
	if ($("#jim_km_designation").val() != "" && $("#jim_km_id").val() != 0) {
		let prev_shirt = $("#prev_shirt_group_count").html();
		let shirt = $("#shirt_group_count").html();
		let total_shirt = parseInt(prev_shirt) + parseInt(shirt);
		$("#total_shirt_group_count").html(total_shirt);

		let prev_pant = $("#prev_pant_group_count").html();
		let pant = $("#pant_group_count").html();
		let total_pant = parseInt(prev_pant) + parseInt(pant);
		$("#total_pant_group_count").html(total_pant);

		let prev_safari = $("#prev_safari_group_count").html();
		let safari = $("#safari_group_count").html();
		let total_safari = parseInt(prev_safari) + parseInt(safari);
		$("#total_safari_group_count").html(total_safari);

		let prev_coat = $("#prev_coat_group_count").html();
		let coat = $("#coat_group_count").html();
		let total_coat = parseInt(prev_coat) + parseInt(coat);
		$("#total_coat_group_count").html(total_coat);

		let prev_other = $("#prev_other_group_count").html();
		let other = $("#other_group_count").html();
		let total_other = parseInt(prev_other) + parseInt(other);
		$("#total_other_group_count").html(total_other);

		let total_prev = 
			parseInt(prev_shirt) +
			parseInt(prev_pant) +
			parseInt(prev_safari) +
			parseInt(prev_coat) +
			parseInt(prev_other);
		$("#prev_total_group_count").html(total_prev);

		let total =
			parseInt(shirt) +
			parseInt(pant) +
			parseInt(safari) +
			parseInt(coat) +
			parseInt(other);
		$("#total_group_count").html(total);
		$("#total_total_group_count").html(
			parseInt(total_shirt) +
				parseInt(total_pant) +
				parseInt(total_safari) +
				parseInt(total_coat) +
				parseInt(total_other)
		);
	} else {
		$("#prev_shirt_group_count").html(0);
		$("#shirt_group_count").html(0);
		$("#total_shirt_group_count").html(0);

		$("#prev_pant_group_count").html(0);
		$("#pant_group_count").html(0);
		$("#total_pant_group_count").html(0);

		$("#prev_safari_group_count").html(0);
		$("#safari_group_count").html(0);
		$("#total_safari_group_count").html(0);

		$("#prev_coat_group_count").html(0);
		$("#coat_group_count").html(0);
		$("#total_coat_group_count").html(0);

		$("#prev_other_group_count").html(0);
		$("#other_group_count").html(0);
		$("#total_other_group_count").html(0);

		$("#prev_total_group_count").html(0);

		$("#total_group_count").html(0);
		$("#total_total_group_count").html(0);
	}
};
const app_group_exist = (app_group, karigar_data) => {
	let isExist = false;
	if (karigar_data.length == 0) return false;
	$.each(karigar_data, (index, value) => {
		if (value.app_group == app_group) {
			isExist = true;
		}
	});
	return isExist;
};
const isBarcodeAdded = (ot_id) => {
	let isExist = false;
	let total_tr = $("#job_issue_body_wrapper tr").length;
	if (total_tr == 0) return isExist;
	for (let i = 1; i <= total_tr; i++) {
		let id = $("#job_issue_body_wrapper tr:nth-child(" + i + ")").attr("id");
		let lastunderscore = id.lastIndexOf("_");
		let cnt = id.substring(lastunderscore + 1);
		if (cnt == ot_id) {
			isExist = true;
		}
	}
	return isExist;
};

const scan_barcode = () => 
{ 
	let ot_barcode = $("#ot_barcode").val();
	let km_id = $("#jim_km_id").val();
	let process_type = $("#jim_km_designation").val();
	let designation = $("#jim_km_designation").val();
	// alert(km_id);
	// alert(ot_barcode);
	if (ot_barcode.trim() !== "" && ot_barcode.length > 8) { 
		let path = `${base_url}/production/job_issue/scan_barcode/${ot_barcode}`;
		ajaxCall( 
			"GET",
			path,
			"",
			"JSON",
			(resp) => {
				const { status,data, msg } = resp;
				if (status) { 
					if (!isBarcodeAdded(data[0]["ot_id"])){
						add_row(data); 
							callToastify("success",
							"Barcode Scanned",
							"right");
						$("#ot_barcode").val('');	
					}else{
						response_error(2,'Barcode Already added in list');
					}
				} else {
					response_error(2, msg);
				}
				
			},
			(errmsg) => {});
	}
	setTimeout(() => {
		$("#bm_item_code").val("").focus();
	}, 2000);
};

const set_header = () => {
	let tr = `<tr>
                <th colspan="10" style="text-align: center;"> NO BARCODE SELECTED</th>
            </tr>`;
	if ($("#job_issue_body_wrapper tr").length > 0) {
		tr = `<tr>
                <th>#</th>
                <th>Barcode</th>
                <th>Product</th>
                <th>Order No</th>
                <th>Order Date</th>
                <th>Delivery Date</th>
                <th>Client</th>
                <th>Remove</th>
            </tr>
            `;
	}
	$("#job_issue_head_wrapper").html(tr);
};
const add_row = (data) => {  
	let total_tr = $("#job_issue_body_wrapper tr").length;
	let sr_no = total_tr + 1;
	let {
		ot_id,
		ot_barcode,
		app_name,
		om_no,
		om_entry_date,
		om_delivery_date,
		client_name,
		client_mobile1,
	} = data[0];
	let td = `<tr id="rowid_${ot_id}">
                <td id="sr_no_${ot_id}">${sr_no}</td>
                <td>
                    <input type="hidden" id="jit_id_${ot_id}" name="jit_id[]" value="0" />
                    <input type="hidden" id="jit_ot_id_${ot_id}" name="jit_ot_id[]" value="${ot_id}" />
                    <input type="hidden" id="jit_otb_barcode_${ot_id}" name="jit_otb_barcode[]" value="${ot_barcode}" />
                    ${ot_barcode}
                </td>
                <td>${app_name}</td>
                <td>${om_no}</td>
                <td>
                    <input 
                        type="hidden" 
                        id="entry_date_${ot_id}" 
                        value="${om_entry_date}" 
                    />
                    <span id="om_date_${ot_id}">${om_entry_date}</span>
                </td>
                <td>${om_delivery_date}</td>
                <td>${client_name}</td>
                
                <td><a class="btn btn-sm btn-danger" onclick="remove_row(${ot_id})"><i class="glyphicon glyphicon-trash" aria-hidden="true"></i></a></td>
            </tr>
    `;

	$("#job_issue_body_wrapper").prepend(td);
	 $('#sbt_btn').prop("disabled", false);
	set_header();
};
const remove_row = (id) => {
	$(`#rowid_${id}`).detach();
	set_header();
	calculate_issued_count();
	callToastify("success", "Barcode remove from list", "right");
};
const calculate_app_group_count = () => {
	let total_tr = $("#job_issue_body_wrapper tr").length;
	let shirt_group = 0;
	let pant_group = 0;
	let coat_group = 0;
	let safari_group = 0;
	let other_group = 0;
	let total_group = 0;
	for (let i = 1; i <= total_tr; i++) {
		let id = $("#job_issue_body_wrapper tr:nth-child(" + i + ")").attr("id");
		let lastunderscore = id.lastIndexOf("_");
		let cnt = id.substring(lastunderscore + 1);
		let group = $(`#app_group_${cnt}`).html();
		if (group == "SHIRT_GROUP") {
			shirt_group = shirt_group + 1;
		}
		if (group == "PANT_GROUP") {
			pant_group = pant_group + 1;
		}
		if (group == "COAT_GROUP") {
			coat_group = coat_group + 1;
		}
		if (group == "SAFARI_GROUP") {
			safari_group = safari_group + 1;
		}
		if (group == "OTHER_GROUP") {
			other_group = other_group + 1;
		}
		total_group =
			shirt_group + pant_group + coat_group + safari_group + other_group;
	}
	$("#shirt_group_count").html(shirt_group);
	$("#pant_group_count").html(pant_group);
	$("#coat_group_count").html(coat_group);
	$("#safari_group_count").html(safari_group);
	$("#other_group_count").html(other_group);
	$("#total_group_count").html(total_group);
	if (total_group > 0) {
		$("#sbt_btn").prop("disabled", false);
	} else {
		$("#sbt_btn").prop("disabled", true);
	}
};

const check_date = () => {
	let isExist = false;
	let total_tr = $("#job_issue_body_wrapper tr").length;
	if (total_tr == 0) return isExist;
	for (let i = 1; i <= total_tr; i++) {
		let id = $("#job_issue_body_wrapper tr:nth-child(" + i + ")").attr("id");
		let lastunderscore = id.lastIndexOf("_");
		let cnt = id.substring(lastunderscore + 1);
		let issue_date = new Date(
			$("#jim_entry_date").val().split("-").reverse().join("-")
		);
		let order_date = new Date(
			$(`#entry_date_${cnt}`).val().split("-").reverse().join("-")
		);
		if (issue_date.getTime() < order_date.getTime()) {
			$(`#om_entry_date_${cnt}`).addClass("text-danger");
			$("#jim_entry_date").css({ "border-color": "red" });
			$("#jim_entry_date").addClass("shake");
			$("#jim_entry_date").on(
				"webkitAnimationEnd oanimationend msAnimationEnd animationend",
				function (e) {
					$("#jim_entry_date").delay(200).removeClass("shake");
				}
			);
			isExist = true;
		} else {
			$(`#om_entry_date_${cnt}`).removeClass("text-danger");
		}
	}
	return isExist;
};

const add_update_issue = (id) => {
	let check = 0;
	event.preventDefault();
	if ($("#jim_entry_date").val() == "") {
		$("#jim_entry_date").css({ "border-color": "red" });
		$("#jim_entry_date").addClass("shake");
		$("#jim_entry_date").on(
			"webkitAnimationEnd oanimationend msAnimationEnd animationend",
			function (e) {
				$("#jim_entry_date").delay(200).removeClass("shake");
			}
		);
		check = 1;
	} else {
		$("#jim_entry_date").css({ "border-color": "#550a06" });
	}
	if (
		$("#jim_km_designation").val() == "" ||
		$("#jim_km_designation").val() < 1
	) {
		$("#jim_km_designation").css({ "border-color": "red" });
		$("#jim_km_designation").addClass("shake");
		$("#jim_km_designation").on(
			"webkitAnimationEnd oanimationend msAnimationEnd animationend",
			function (e) {
				$("#jim_km_designation").delay(200).removeClass("shake");
			}
		);
		check = 1;
	} else {
		$("#jim_km_designation").css({ "border-color": "#550a06" });
	}

	if ($("#jim_km_id").val() == "" || $("#jim_km_id").val() < 1) {
		$("#jim_km_id").css({ "border-color": "red" });
		$("#jim_km_id").addClass("shake");
		$("#jim_km_id").on(
			"webkitAnimationEnd oanimationend msAnimationEnd animationend",
			function (e) {
				$("#jim_km_id").delay(200).removeClass("shake");
			}
		);
		check = 1;
	} else {
		$("#jim_km_id").css({ "border-color": "#550a06" });
	}
	if ($("#job_issue_body_wrapper tr").length < 1) {
		check = 1;
	}

	if (check) {
		$("body, html").animate({ scrollTop: 0 }, 1000);
	} else if (check_date()) {
		callToastify(
			"error",
			"Issue date before order date are not accepted.",
			"right"
		);
	} else {
		let path = base_url + "production/job_issue/add_update/" + id;
		let form_data = $("#job_issue_form").serialize();
		ajaxCall(
			"POST",
			path,
			form_data,
			"JSON",
			function (resp) {
				const { status, flag, data, msg } = resp;
				if (status) {
					if (flag == 1) {
						if (id == 0) {
						} else {
						}
						callToastify("success", msg, "right");
						$("body, html").animate({ scrollTop: 0 }, 1000);
						setTimeout(function () {
							window.location.reload();
						}, 1000);
					} else {
						response_error(flag, msg);
					}
				} else {
					session_expired();
				}
			},
			(errmsg) => {}
		);
	}
};

const remove_master = (id) => {
	var ans=confirm('Are you sure to delete');
	if (ans)
	{
		let path = base_url + "production/job_issue/remove/"+id;
		ajaxCall("POST",path,'',"JSON",function (resp) {
				const { status, flag, data, msg } = resp;
				if (status) {
					if (flag == 1) {
						if (id == 0) {
						} else {
						}
						callToastify("success", msg, "right");
						$("body, html").animate({ scrollTop: 0 }, 1000);
						setTimeout(function () {
							window.location.reload();
						}, 1000);
					} else {
						response_error(flag, msg);
					}
				} else {
					session_expired();
				}
			},
			(errmsg) => {}
		);
	}
	
};
